/*
 * Decompiled with CFR 0.152.
 */
package ch.qos.logback.core.util;

import ch.qos.logback.core.spi.ContextAware;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;

public class FileUtil {
    public static URL fileToURL(File file) {
        try {
            return file.toURI().toURL();
        }
        catch (MalformedURLException e) {
            throw new RuntimeException("Unexpected exception on file [" + file + "]", e);
        }
    }

    public static boolean isParentDirectoryCreationRequired(File file) {
        File parent = file.getParentFile();
        return parent != null && !parent.exists();
    }

    public static boolean createMissingParentDirectories(File file) {
        File parent = file.getParentFile();
        if (parent == null) {
            throw new IllegalStateException(file + " should not have a null parent");
        }
        if (parent.exists()) {
            throw new IllegalStateException(file + " should not have existing parent directory");
        }
        return parent.mkdirs();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String resourceAsString(ContextAware ca, ClassLoader classLoader, String resourceName) {
        URL url = classLoader.getResource(resourceName);
        if (url == null) {
            ca.addError("Failed to find resource [" + resourceName + "]");
            return null;
        }
        InputStreamReader isr = null;
        try {
            URLConnection urlConnection = url.openConnection();
            urlConnection.setUseCaches(false);
            isr = new InputStreamReader(urlConnection.getInputStream());
            char[] buf = new char[128];
            StringBuilder builder = new StringBuilder();
            int count2 = -1;
            while ((count2 = isr.read(buf, 0, buf.length)) != -1) {
                builder.append(buf, 0, count2);
            }
            String string2 = builder.toString();
            return string2;
        }
        catch (IOException e) {
            ca.addError("Failled to open " + resourceName, e);
        }
        finally {
            if (isr != null) {
                try {
                    isr.close();
                }
                catch (IOException e) {}
            }
        }
        return null;
    }
}

